@extends('layouts.layout')

@section('content')
    <!-- Content Wrapper. Contains page content -->
    <div class="content-wrapper">
        <!-- Content Header (Page header) -->
        <div class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h1 class="m-0 text-dark">Redeem Code</h1>
                    </div><!-- /.col -->
                    <div class="col-sm-6">
                        <ol class="breadcrumb float-sm-right">
                            <li class="breadcrumb-item"><a href="{{ route('home') }}">Home</a></li>
                            <li class="breadcrumb-item active">Redeem</li>
                        </ol>
                    </div><!-- /.col -->
                </div><!-- /.row -->
            </div><!-- /.container-fluid -->
        </div>
        <!-- /.content-header -->
        <section class="content">
            <div class="container-fluid">
                <div class="row">

                    <div class="col-md-6">

                        <div class="info-box">
                            <span class="info-box-icon bg-success"><i class="fas fa-dollar-sign"></i></span>
                            <div class="info-box-content">
                                <span class="info-box-text">Current Balance</span>
                                <span
                                    class="info-box-number">{{ App\Models\Reseller::firstWhere('user_id', Auth::id())->balance }}$</span>
                            </div>
                        </div>
                        <div class="card card-primary">
                            <div class="card-header">
                                <h3 class="card-title">Redeem Code</h3>
                            </div>


                            <form action="{{ route('redeem.submit') }}" method="POST" data-dashlane-rid="092ab22141c160a0"
                                data-form-type="other">
                                @csrf
                                <div class="card-body">
                                    @error('code')
                                        <div class="alert alert-danger">{{ $message }}</div>
                                    @enderror
                                    <div class="form-group">
                                        <label for="redeem-code">Redeem Code</label>
                                        <input type="text" class="form-control" name="code"
                                            placeholder="Enter Redeem Code Here" data-dashlane-rid="564298be310d5b11"
                                            data-form-type="other" value="{{ old('code') }}">
                                    </div>
                                </div>

                                <div class="card-footer">
                                    <button type="submit" class="btn btn-primary" data-dashlane-rid="26dd55dba4d96914"
                                        data-dashlane-label="true" data-form-type="action">Redeem</button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </div>
    <!-- /.content -->
@endsection
